1. N+1 Queries
**Always** query all data you need before executing anything.

Incorrect:
```C#
foreach (var id in itemIds)
{
  await _context.Items.FirstOrDefaultAsync(x => x.Id == id);
  // Logic
  await _context.SaveChangesAsync();
}
```

Correct:
```C#
var items = await _context.Items.Where(x => itemIds.Contains(x.Id));
foreach (var item in items)
{
  // Logic
}
await _context.SaveChangesAsync();
```

2. 3+ Includes without AsSplitQuery()
**Always** consider the query that will actually be executed.

Incorrect
```C#
await _context.Users
  .Include(u => u.Roles)
  .Include(u => u.Events)
  .Include(u => u.Installations)
  .ThenInclude(i => i.Meters)
  .ToListAsync();
```

Correct:
```C#
await _context.Users
  .Include(u => u.Roles)
  .Include(u => u.Events)
  .Include(u => u.Installations)
  .ThenInclude(i => i.Meters)
  .AsSplitQuery()
  .ToListAsync();
```

3. Todos without issues
You **will** forget.

```C#
var theThing = getTheThing(); // TODO: Do the right thing!
```

```C#
var theThing = getTheThing(); // TODO: Do the right thing! (#8383)
```